#include <bits/stdc++.h>
using namespace std;

struct Node {
  int idx;
  Node *lft, *rig;
  int clr_lft, clr_rig;
  Node(int idx) : idx(idx) {}
  bool isDiff() const {
    return clr_lft != clr_rig;
  }
};

typedef pair <Node*, Node*> pnn;

int N;
set <Node*> diff;
vector <pnn> cands[3];
map <pnn, int> memo;
Node* head;

void load() {
  scanf("%d%*d", &N);
}

void output(pnn p) {
  printf("%d %d\n", p.first -> idx, p.second -> idx);
}

int ask(Node* x, Node* y) {
  if (x > y)
    swap(x, y);
  int &ref = memo[{x, y}];
  if (ref)
    return ref;
  printf("? "); 
  output({x, y});
  fflush(stdout);
  scanf("%d", &ref);
  return ref;
}

void add_diff(Node* x) {
  if (x -> isDiff())
    diff.insert(x);
}

void link(Node* l, Node* r) {
  l -> rig = r;
  r -> lft = l;
  l -> clr_rig = r -> clr_lft = ask(l, r);
}

void induct(Node* x) {
  Node* l = x -> lft;
  Node* r = x -> rig;
  diff.erase(x);
  diff.erase(l);
  diff.erase(r);
  cands[x -> clr_lft].push_back({x, l});
  cands[x -> clr_rig].push_back({x, r});
  link(l, r);
  add_diff(l);
  add_diff(r);
  head = r;
}

void solve() {
  head = new Node(1);
  Node* prev = head;
  for (int i = 2; i <= N; i++) {
    Node* curr = new Node(i);
    link(prev, curr);
    prev = curr;
  }
  link(prev, head);
  for (int i = 0; i < N; i++) {
    add_diff(head);
    head = head -> rig;
  }
  while (!diff.empty()) 
    induct(*diff.begin());
  int fin_clr = head -> clr_rig;
  printf("! %d\n", fin_clr);
  for (auto it : cands[fin_clr])
    output(it);
  for (int i = cands[fin_clr].size(); i < N - 1; i++) {
    output({head, head -> rig});
    head = head -> rig;
  }
  fflush(stdout);
}

int main() {
  load();
  solve();
  return 0;
}
